% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/internal_functions.R
\name{stsSD}
\alias{stsSD}
\title{Build sts object}
\usage{
stsSD(observedCases, studyPeriod, timeUnit = "Month", startYM = c(2000, 1) )
}
\arguments{
\item{observedCases}{numeric vector of the number of cases by time unit (y axis of the time series)}

\item{studyPeriod}{vector of dates of length(obeservedCases) (x axis of the time series)}

\item{timeUnit}{character string for the time unit of the time series. Options are Week or Month.}

\item{startYM}{numeric vector including Year and Month of start of the historical data}
}
\value{
sts
}
\description{
Build sts surveillance object
}
\examples{
#-- Setting the parameters to run the report for
input <- list(
disease = "Salmonellosis",
country = "EU-EEA - complete series",
indicator = "Reported cases",
stratification = "Confirmed cases",
unit = "Month",
daterange = c("2010-01-01", "2016-12-31"),
algo = "FarringtonFlexible",
testingperiod = 5
)

#-- Example dataset
dataset <- EpiSignalDetection::SignalData

#-- Filtering on declared input parameters
dataset <- filterAtlasExport(dataset, input)

#-- Aggregating the data by geographical level and time point
dataset <- aggAtlasExport(dataset, input)

#-- Bulding the corresponding sts object
dataset.sts <- stsSD(observedCases = dataset$NumValue,
                     studyPeriod = dataset$StudyPeriod,
                     timeUnit = input$unit,
                     startYM = c(as.numeric(format(as.Date(input$daterange[1], "\%Y-\%m-\%d"), "\%Y")),
                                 as.numeric(format(as.Date(input$daterange[1], "\%Y-\%m-\%d"), "\%m"))))

}
\seealso{
\code{\link{aggAtlasExport}} \code{\link{algoSD}}
}
