% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/validation.R
\name{validate_model}
\alias{validate_model}
\title{Comprehensive Model Validation}
\usage{
validate_model(
  equation,
  sde = NULL,
  data,
  response = NULL,
  derivative_col = NULL,
  variable,
  time_col = "time",
  cv_folds = 5,
  n_sims = 50,
  expected_features = list(),
  verbose = TRUE
)
}
\arguments{
\item{equation}{Fitted equation object.}

\item{sde}{SDE object (optional, for trajectory validation).}

\item{data}{Original data frame.}

\item{response}{Name of response column.}

\item{derivative_col}{Alias for response (for compatibility).}

\item{variable}{Main variable name.}

\item{time_col}{Time column name.}

\item{cv_folds}{Number of CV folds.}

\item{n_sims}{Number of trajectory simulations.}

\item{expected_features}{List of expected qualitative features.}

\item{verbose}{Print progress.}
}
\value{
Object of class "validation_result".
}
\description{
Runs a battery of validation tests on the discovered equation.
}
