% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/symbolic_search.R
\name{estimate_initial_values}
\alias{estimate_initial_values}
\title{Automatic Initial Value Estimation}
\usage{
estimate_initial_values(
  expression,
  data,
  response = NULL,
  derivative_col = NULL,
  method = c("grid_search", "random", "heuristic"),
  n_tries = 100
)
}
\arguments{
\item{expression}{Character string with the equation expression.}

\item{data}{Data frame with variables.}

\item{response}{Name of the response variable.}

\item{derivative_col}{Alias for response (for compatibility).}

\item{method}{Estimation method: "grid_search", "random", or "heuristic".}

\item{n_tries}{Number of attempts for random method.}
}
\value{
Named list of initial values.
}
\description{
Estimates reasonable starting values for nonlinear least squares.
}
