% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/effectLite_iht.R
\name{effectLite_iht}
\alias{effectLite_iht}
\title{Informative hypothesis tests for effectLite}
\usage{
effectLite_iht(object, constraints = NULL, test = "default")
}
\arguments{
\item{object}{effectlite. Fitted model of class effectlite estimated with \code{\link[EffectLiteR]{effectLite}} using \code{method="sem"}.}

\item{constraints}{character. Specification of constraints for the ordered hypothesis test.}

\item{test}{character. Statistical test to be used for the ordered hypothesis test. Can be one of \code{c("default", "Fbar", "Wald")}.}
}
\value{
list with test statistics and p-value.
}
\description{
Informative hypothesis tests for effectLite
}
\examples{
m1 <- effectLite(y="dv", x="x", k="k1", z="z1", method = "sem", 
                 fixed.cell=TRUE, fixed.z=TRUE, data=example01)
test <- effectLite_iht(object = m1, 
                       constraints = 'adjmean2 > adjmean1
                                      adjmean1 > adjmean0')
print(test)

}
