% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/EcotoneFinder.R
\name{EcotoneFinderSeries}
\alias{EcotoneFinderSeries}
\title{Extension of EcotoneFinder for space/time series}
\usage{
EcotoneFinderSeries(data, dist, series = NULL, method = c("dca",
  "fanny", "vegclust", "diversity", "cmeans", "all"), groups = NULL,
  m.exp = 2, standardize = NULL, diversity = c("shannon", "richness",
  "expShannon", "pielou", "all"), na.rm = FALSE)
}
\arguments{
\item{data}{A list of dataframes corresponding to the series or a single
dataframe with a series factor. Species must appear as columns.}

\item{dist}{A vector or column containing the gradient along which the
analysis will be done. Must be of the same lenght as data.}

\item{series}{If data is a single dataframe, must be the name or the number of
the factor column identifying the series.}

\item{method}{One of c("dca", "fanny", "vegclust", "diversity", "cmeans", "all").
Tell the function which analysis to perform. See details.}

\item{groups}{Interger. The desired number of clusters if any of the
clustering method is selected.}

\item{m.exp}{Integer. The membership exponent for any of the clustering
method.}

\item{standardize}{Standardize method to apply to the data before further
analysis (for fanny and cmeans). Must be one of decostand methods (see
decostand).}

\item{diversity}{diversity indice to be calculated. See details.}

\item{na.rm}{Logical. Should NAs be removed.}
}
\value{
A list of lists containing the outcomes of the EcotoneFinder function
 for each series.
}
\description{
Extension of EcotoneFinder for space/time series
}
\details{
EcotoneFinderSeries is a generalisation of the EcotoneFinder function
 to handle space/time series of data. If a dataframe is provided, it will
 convert it internally to a named list according to the factor provided by
 the series argument. The methods of analysis and standardizations, as well
 as the diversity indices are the same as those of the EcotoneFinder
 function.
}
\examples{
 ############# Synthetic time series data:
 SyntheticTrialSeries <- SyntheticDataSeries(CommunityPool = 40,
                                             CommunityNum = 4, SpCo = NULL,
                                             Length = 500, SeriesNum = 5,
                                             Parameters = list(a=rep(60, 4),
                                                               b=c(0,200,350,500),
                                                               c=rep(0.03,4)),
                                             dev.c = .015,
                                             pal = c("#008585", "#B8CDAE", "#E6C186", "#C7522B"),
                                             replacement = FALSE,
                                             Parameters.repl = TRUE)

 EcoTimeSeriesTrial <- EcotoneFinderSeries(data = SyntheticTrialSeries,
                                           dist = "Distance", method = "cmeans",
                                           series = "Time", groups = 4,
                                           standardize = "hellinger", na.rm = TRUE)



}
