% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/EQRN.R
\name{loss_GPD_tensor}
\alias{loss_GPD_tensor}
\title{GPD tensor loss function for training a EQRN network}
\usage{
loss_GPD_tensor(
  out,
  y,
  orthogonal_gpd = TRUE,
  shape_penalty = 0,
  prior_shape = NULL,
  return_agg = c("mean", "sum", "vector", "nanmean", "nansum")
)
}
\arguments{
\item{out}{Batch tensor of GPD parameters output by the network.}

\item{y}{Batch tensor of corresponding response variable.}

\item{orthogonal_gpd}{Whether the network is supposed to regress in the orthogonal reparametrization of the GPD parameters (recommended).}

\item{shape_penalty}{Penalty parameter for the shape estimate, to potentially regularize its variation from the fixed prior estimate.}

\item{prior_shape}{Prior estimate for the shape, used only if \code{shape_penalty>0}.}

\item{return_agg}{The return aggregation of the computed loss over the batch. Must be one of \verb{"mean", "sum", "vector", "nanmean", "nansum"}.}
}
\value{
The GPD loss over the batch between the network output and the observed responses as a \code{torch::Tensor},
whose dimensions depend on \code{return_agg}.
}
\description{
GPD tensor loss function for training a EQRN network
}
