% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/EMSanova.R
\name{EMSanova}
\alias{EMSanova}
\title{Calculate ANOVA table with EMS}
\usage{
EMSanova(formula,data,type=NULL,nested=NULL,
                 level=NULL,approximate=FALSE)
}
\arguments{
\item{formula}{model formula}

\item{data}{data frame for ANOVA}

\item{type}{the list of fixed/random for each factor. 
"F" for the fixed effect, "R" for the random effect}

\item{nested}{the list of nested effect}

\item{level}{list of model level}

\item{approximate}{calculate approximated F for "TRUE"}
}
\description{
Calculate ANOVA table with EMS for various experimental design - factorial design, nested
design, mixed effect model, etc.
}
\examples{
data(baseball)
anova.result<-EMSanova(velocity~Group+Subject+test,data=baseball,
                 type=c("F","R","F"),
                 nested=c(NA,"Group",NA),
                 level=c(1,1,2))
anova.result                  
}
