% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/run_bootstraps.R
\name{run_bootstraps}
\alias{run_bootstraps}
\title{Run bootstrapping routine}
\usage{
run_bootstraps(eList, type_results, jitterOn, V, blockLength, startSeed, nBoot,
  type, run.parallel)
}
\arguments{
\item{eList}{named list with at least the Daily, Sample, and INFO dataframes}

\item{type_results}{data frame returned from either \code{\link[EGRET]{runGroups}}
or \code{\link[EGRET]{runPairs}} depending on context.}

\item{jitterOn}{logical, if TRUE, adds "jitter" to the data in an attempt to avoid some numerical problems.
Default = FALSE.  See Details below.}

\item{V}{numeric a multiplier for addition of jitter to the data, default = 0.2.}

\item{blockLength}{integer size of subset, expressed in days.  200 days has been found to be a good choice.}

\item{startSeed}{sets the random seed value. This is used to make repeatable output.}

\item{nBoot}{the maximum number of bootstrap replicates to be used, typically 100}

\item{type}{Character can be "pair" or "group".}

\item{run.parallel}{logical to run bootstrapping in parallel or not}
}
\description{
Depending on input arguments, this function will run
a complete bootstrapping routine either in series or parallel.
}
\details{
When in parallel, if there are unsuccessful runs, they will be made
up in series after the parallel runs are done.#'
}
\keyword{internal}
