% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fwave.R
\name{detect_QRS}
\alias{detect_QRS}
\title{Detect QRS complexes in ECG signals}
\usage{
detect_QRS(signal, frequency, window_size = 0.15)
}
\arguments{
\item{signal}{Numeric vector representing the ECG signal}

\item{frequency}{Sampling frequency of the signal in Hz}

\item{window_size}{Width of the integration window in seconds, default is
0.150 seconds}
}
\value{
Integer vector containing the sample indices of detected QRS
complexes
}
\description{
\code{detect_QRS()} implements a modified Pan-Tompkins algorithm to
detect QRS complexes in ECG signals. The function applies a sequence of
processing steps including bandpass filtering, differentiation, squaring, and
moving window integration to identify R peaks in the signal.
}
\details{
The Pan-Tompkins algorithm is a widely-used method for QRS detection
in ECG signals. This implementation follows these steps:
\enumerate{
\item Bandpass filtering (5-15 Hz) to reduce noise and emphasize QRS complexes
\item Differentiation to highlight the steep slopes of QRS complexes 3. Squaring
to amplify high-frequency components 4. Moving window integration to consider
the overall QRS morphology 5. Adaptive thresholding to identify peaks 6.
Application of a refractory period to prevent multiple detections of the same
QRS complex
}

The function is designed to work with single-lead ECG signals, typically
sampled at 250-1000 Hz.
}
\examples{
\dontrun{
# Load ECG data
ecg_data <- read_muse(system.file("extdata", "muse-sinus.xml", package = "EGM"))

# Extract lead II signal
signal <- ecg_data$signal$II

# Get sampling frequency from header
freq <- attributes(ecg_data$header)$record_line$frequency

# Detect QRS complexes
qrs_locations <- detect_QRS(signal, freq)

# Plot ECG with detected QRS complexes
plot(signal, type = "l", xlab = "Sample", ylab = "Amplitude")
points(qrs_locations, signal[qrs_locations], col = "red", pch = 19)
}

}
\references{
Pan, J., & Tompkins, W. J. (1985). A real-time QRS detection
algorithm. IEEE Transactions on Biomedical Engineering, (3), 230-236.
\doi{10.1109/TBME.1985.325532}
}
