% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/EWMA_p_chart_two.R
\name{EWMA_p_chart_two}
\alias{EWMA_p_chart_two}
\title{A two-sided EWMA-p control chart}
\usage{
EWMA_p_chart_two(
  ICdata,
  OCdata,
  lambda,
  n,
  pi1 = 1,
  pi2 = pi1,
  ARL0 = 200,
  M = 500,
  error = 10
)
}
\arguments{
\item{ICdata}{The in-control data for attributes.}

\item{OCdata}{The out-of-control data for attributes.}

\item{lambda}{An EWMA smooth constant, which is a scalar in [0,1].}

\item{n}{A sample size in the data.}

\item{pi1}{The proportion that the observed defectives are the same as unobserved ones.}

\item{pi2}{The proportion that the observed non-defectives are the same as unobserved ones.}

\item{ARL0}{A prespecified average run length (ARL) of a control chart in the in-control process.}

\item{M}{The number of simulation times for the Monte Carlo method}

\item{error}{The tolerant for the absolute difference between an iterated ARL value and prespecified \code{ARL0}.}
}
\value{
The first chart is an EWMA-p chart obtained by the in-control data, and the second chart is an EWMA-p chart based in the out-of-control data.
In two figures, horizontal solid lines represents upper control limit (UCL) and lower control limit (LCL), black solid dots are detections of in-control data, and red solid dots are detections of out-of-control data.
}
\description{
This function displays two-sided EWMA-p chart control charts based on in-control and out-of-control data that are number of defectives.
In the presence of measurement error, this function is able to provide suitable charts with corrections of measurement error effects.
}
\examples{
library(qcr)
data = orangejuice
IC = data[31:54,1]
OC = data[1:30,1]
set.seed(2)
EWMA_p_chart_two(IC,OC,0.05,50,1,1,200,100,20)
}
\references{
Chen, L.-P. & Yang, S.-F. (2022). A new p-chart with measurement error correction. arXiv: 2203.03384.
}
