% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/refit.R
\name{refit}
\alias{refit}
\title{Refit LASSO estimate into GLS}
\usage{
refit(X, Y, beta)
}
\arguments{
\item{X}{Aggregated indicator series matrix that has been GLS rotated (an \eqn{n_l \times p} matrix).}

\item{Y}{Low-frequency response vector that has been GLS rotated (an \eqn{n_l \times 1} vector).}

\item{beta}{Estimated beta coefficients from the LARS algorithm (a \eqn{p \times 1} vector).}
}
\value{
\if{html}{\out{<div class="sourceCode">}}\preformatted{ A debiased estimate of the beta coefficients (a \eqn{p \times 1} vector).
}\if{html}{\out{</div>}}
}
\description{
This function reduces the bias in LASSO estimates by re-fitting the
active set of coefficients back into GLS (Generalized Least Squares).
}
\keyword{internal}
