% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Main.R
\name{fitBoosted}
\alias{fitBoosted}
\title{Simple Gradient Boosting}
\usage{
fitBoosted(formula, data, iterations = 100, verbose = TRUE)
}
\arguments{
\item{formula}{an object of class "\link{formula}" with a response but no interaction terms.
The response variable should be a binomial factor that has values of \code{1} for a positive response
or \code{-1} for a negative or lack of response.}

\item{data}{the dataframe containing the independent variables and the response}

\item{iterations}{The number of training rounds for boosting.}

\item{verbose}{should the current training round be printed to the console?}
}
\value{
An S3 object of class \code{boosted}. This includes
}
\description{
Fit a simple, educational implementation of tree-based gradient boosting model.
}
\examples{
k <- kyphosis
k$Kyphosis <- factor(ifelse(k$Kyphosis == "present", 1L, -1L))
fit <- fitBoosted(Kyphosis ~ Age + Number + Start, data = k, iterations = 10)

}

