% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FisherZ.R
\name{FisherZ}
\alias{FisherZ}
\alias{FisherZInv}
\title{Fisher z-Transformation}
\usage{
FisherZ(rho)

FisherZInv(z)
}
\arguments{
\item{rho}{the Pearson's correlation coefficient}

\item{z}{a Fisher z transformed value}
}
\value{
z value corresponding to r (in FisherZ) \cr r corresponding to z (in
FisherZInv) \cr
}
\description{
Convert a correlation to a z score or z to r using the Fisher transformation.
}
\details{
The sampling distribution of Pearson's r is not normally distributed. Fisher
developed a transformation now called "Fisher's z-transformation" that
converts Pearson's r to the normally distributed variable z. The formula for
the transformation is:

\deqn{z_r = tanh^{-1}(r) = \frac{1}{2}log\left ( \frac{1+r}{1-r}\right )}
}
\examples{

cors <- seq(-.9, .9, .1)

zs <- FisherZ(cors)
rs <- FisherZInv(zs)
round(zs, 2)
n <- 30
r <- seq(0, .9, .1)
rc <- t(sapply(r, CorCI, n=n))
t <- r * sqrt(n-2) / sqrt(1-r^2)
p <- (1 - pt(t, n-2)) / 2

r.rc <- data.frame(r=r, z=FisherZ(r), lower=rc[,2], upper=rc[,3], t=t, p=p)

round(r.rc,2)

}
\seealso{
\code{\link{cor.test}}
}
\author{
William Revelle \href{mailto:revelle@northwestern.edu}{revelle@northwestern.edu}, \cr slight
modifications Andri Signorell \href{mailto:andri@signorell.net}{andri@signorell.net} based on R-Core code
}
\keyword{models}
\keyword{multivariate}
