% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/het.var.R
\name{het.var}
\alias{het.var}
\title{Variances per varGroup stratum for heteroscedastic models}
\usage{
het.var(model)
}
\arguments{
\item{model}{a class "\code{lme}" model produced by \code{\link{dendro.varcov}} with \code{homoscedastic} equals \code{FALSE}.}
}
\value{
The function returns a \code{numeric} vector containing the variance per each level of \code{varGroup}. They are used internally to calculate synchrony (\code{\link{sync}}).
}
\description{
The function obtains the heteroscedastic variances for each \code{varGroup} elements for a selected model (mHeCS, mHeUN, mHeNE).
}
\details{
The function extracts the variances for each \code{varGroup} stratum using the within-group heteroscedastic structure of the fitted models (\code{varIdent} constant variance per stratum).
 Note that this function only works for heteroscedastic models: mHeCS, mHeNE,mHeUN.
}
\examples{
## Calculate within-group heteroscedastic variances for conifersIP data:
 data(conifersIP)
 
 #Fit the heteroscedastic set of models (mBE, mHeCS, mHeNE, mHeUN)
 # using taxonomic grouping criteria (i.e. Species)
 ModHt <- dendro.varcov(TRW ~ Code, varTime = "Year", varGroup = "Species", 
                        data = conifersIP, homoscedastic = FALSE)
 
 #Obtain the within-group variances for the model of interest
 het.var(ModHt$mHeCS)#Heterogeneous variant of compound symmetry model
 het.var(ModHt$mHeUN)#Heterogeneous unstructured model
 
}
\author{
Josu G. Alday, Tatiana A. Shestakova, Victor Resco de Dios, Jordi Voltas
}
