% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plots.R
\name{conformal_plot}
\alias{conformal_plot}
\title{conformal_plot}
\usage{
conformal_plot(
  x,
  ...,
  seed = 1234,
  prop = 0.3,
  binary.outcome = FALSE,
  x.labels = TRUE,
  x.title = "Observations",
  color = "steelblue",
  break.by = 0.5
)
}
\arguments{
\item{x}{A fitted model object of class \code{metalearner_ensemble}
or \code{metalearner_deeplearning} that contains a \code{conformal_interval} element.}

\item{...}{Additional arguments (currently unused).}

\item{seed}{Random seed for reproductibility of subsampling. Default is \code{1234}.}

\item{prop}{Proportion of observations to randomly sample for plotting.
Must be between 0 and 1. Default is \code{0.3}.}

\item{binary.outcome}{Logical; if \code{TRUE}, constrains the y-axis to
\code{[-1, 1]} for binary outcomes. Default is \code{FALSE}.}

\item{x.labels}{Logical; if \code{TRUE}, displays x-axis labels for each sampled observation.
Default is \code{TRUE}.}

\item{x.title}{Character string specifying the x-axis title.
Default is \code{"Observations"}.}

\item{color}{Color of the conformal intervals and points.
Default is \code{"steelblue"}.}

\item{break.by}{Numeric value determining the spacing between y-axis breaks.
Default is \code{0.5}.}
}
\value{
A \code{ggplot} object showing sampled individual treatment effects
with their weighted conformal prediction intervals.
}
\description{
Visualizes the distribution of estimated individual treatment effects (ITEs)
along with their corresponding conformal prediction intervals.
The function randomly samples a proportion of observations from a fitted
\code{metalearner_ensemble} or \code{metalearner_deeplearning} object and
plots the conformal intervals as vertical ranges around the point estimates.
This allows users to visually assess the uncertainty and variation in
estimated treatment effects.
}
\details{
The function extracts the estimated ITEs (\code{CATEs}) and conformal intervals
(\code{ITE_lower}, \code{ITE_upper}) from the model output, samples a subset
of rows, and generates a \code{ggplot2} visualization.
Each vertical line represents the conformal prediction interval for one observation’s
treatment effect estimate.
The conformal intervals are typically obtained from weighted split-conformal inference,
using propensity overlap weights to adjust interval width.
}
