% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NARDL.R
\name{NARDL}
\alias{NARDL}
\title{Dual Wavelet-based NARDL Model}
\usage{
NARDL(Data, Exo, MaxLag, Trend = TRUE)
}
\arguments{
\item{Data}{A time series object (numeric vector) representing the dependent variable.}

\item{Exo}{A time series object (numeric vector) representing the exogenous variable.}

\item{MaxLag}{Maximum number of lags to consider.}

\item{Trend}{Boolean to include trend in the model. Default is TRUE.}
}
\value{
A list containing:
\item{Coefficients}{Model coefficients (short and long run).}
\item{AsymTest}{Wald test statistics and p-values.}
\item{IC}{Information criteria (AIC, BIC, Log-likelihood).}
}
\description{
This function implements the Dual Wavelet-based Nonlinear Autoregressive Distributed Lag (NARDL) model.
}
\examples{
Data <- rnorm(100)
Exo <- rnorm(100)
Results <- NARDL(Data, Exo, MaxLag = 3)
}
\references{
Jammazi, R., Lahiani, A., & Nguyen, D. K. (2015). A wavelet-based nonlinear ARDL model for assessing the exchange rate pass-through to crude oil prices. *Journal of International Financial Markets, Institutions and Money, 34*, 173-187. https://doi.org/10.1016/j.intfin.2014.11.011
}
