% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/4_7DTWUMI_general.R
\name{DTWUMI_imputation}
\alias{DTWUMI_imputation}
\title{Large gaps imputation based on DTW for multivariate signals}
\usage{
DTWUMI_imputation(data, gap_size_threshold, DTW_method = "DTW",
  threshold_cos = 0.995, thresh_cos_stop = 0.8, step_threshold = 2, ...)
}
\arguments{
\item{data}{a multivariate signals containing gaps}

\item{gap_size_threshold}{threshold above which dtw based imputation is computed. Below this threshold, a weighted moving average is calculated}

\item{DTW_method}{DTW method used for imputation ("DTW", "DDTW", "AFBDTW"). By default "DTW"}

\item{threshold_cos}{threshold used to define similar sequences to the query}

\item{thresh_cos_stop}{Define the lowest cosine threshold acceptable to find a similar window to the query}

\item{step_threshold}{step used within the loops determining the threshold and the most similar sequence to the query}

\item{...}{additional arguments from dtw() function}
}
\value{
returns a list containing a dataframe of completed signals
}
\description{
Fills all gaps within a multivariate signal. Gaps of size 1 are filled using the average values of nearest neighbours.
Gaps of size >1 and <gap_size_threshold are filled using weighted moving average. Larger gaps are filled using DTW.
}
\examples{
data(dataDTWUMI)
dataDTWUMI_gap <- dataDTWUMI[["incomplete_signal"]]
imputation <- DTWUMI_imputation(dataDTWUMI_gap, gap_size_threshold = 10)
plot(dataDTWUMI_gap[, 1], type = "l", lwd = 2)
lines(imputation$output[, 1], col = "red")
plot(dataDTWUMI_gap[, 2], type = "l", lwd = 2)
lines(imputation$output[, 2], col = "red")
plot(dataDTWUMI_gap[, 3], type = "l", lwd = 2)
lines(imputation$output[, 3], col = "red")
}
\author{
DEZECACHE Camille, PHAN Thi Thu Hong, POISSON-CAILLAULT Emilie
}
