% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DSSession.R
\name{dsStateMessage}
\alias{dsStateMessage}
\title{Get the state of the remote R session}
\usage{
dsStateMessage(session)
}
\arguments{
\item{session}{An object inheriting from \code{\link{DSSession-class}}.}
}
\value{
A character string
}
\description{
Get a human-readable message that informs about the state of the remote R session.
The primary use of this function is to inform the user about the session state process 
after it has been created in an asynchronous way.
}
\examples{
\dontrun{
con <- dsConnect(DSOpal::Opal(), "server1",
  username = "dsuser", password = "password", url = "https://opal-demo.obiba.org")
session <- dsSession(con, async = TRUE)
ready <- dsIsReady(session)
while (!ready) {
  Sys.sleep(1)
  ready <- dsIsReady(session)
  cat(dsStateMessage(session), "\n")
}
dsDisconnect(con)
}
}
\seealso{
Other DSSession generics: 
\code{\link{DSSession-class}},
\code{\link{dsIsReady}()}
}
\concept{DSSession generics}
