% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DPtree.R
\name{DPTreeDensity}
\alias{DPTreeDensity}
\title{Calculating sub-partition probabiltiy measures for a realized distribution from D-P tree.}
\usage{
DPTreeDensity(Z)
}
\arguments{
\item{Z}{An array of dimension of \eqn{2^m} by \eqn{2^m} by m, m being the approximation level.
Realized Z's for all partitions at each level,
as returned by \code{RealizeDPTree}.}
}
\value{
A \eqn{2^m} by \eqn{2^m} matrix. Normalized measures for all \eqn{2^m} by \eqn{2^m} sub-partititons on copula space
given by the realized distribution from D-P tree.
}
\description{
\code{DPTreeDensity} returns
the probablity measures in the finest sub-partitions of a realized distribution from D-P tree prior/posterior.
}
\examples{
dp.rlz <- RealizeDPTree(DPTreePrior(m=2, z=1))
DPTreeDensity(dp.rlz)
}
\references{
\insertRef{DPtree}{DPtree}
}
