# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' @title Extract VCF information
#'
#' @description Extract VCF information
#'
#' @param filename VCF file name.
#'
#' @param samplename Sample name
#'
#' @seealso
#' \itemize{
#'   \item \code{extractCoverageFromVcf}
#'   \item \code{extractCoverageFromTxt}
#' }
#'
#' @return A dataframe list with members of haplotypes, proportions and log likelihood of the MCMC chain.
#' \itemize{
#'   \item \code{CHROM} SNP chromosomes.
#'   \item \code{POS} SNP positions.
#'   \item \code{refCount} reference allele count.
#'   \item \code{altCount} alternative allele count.
#' }
#'
#' @export
#'
#' @examples
#' vcfFile = system.file("extdata", "PG0390-C.test.vcf.gz", package = "DEploid.utils")
#' vcf = extractCoverageFromVcf(vcfFile, "PG0390-C")
#'
extractCoverageFromVcf <- function(filename, samplename) {
    .Call(`_DEploid_utils_extractCoverageFromVcf`, filename, samplename)
}

