% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DexiCharts.R
\name{scale_alternatives}
\alias{scale_alternatives}
\title{scale_alternatives}
\usage{
scale_alternatives(
  model,
  alternatives = NULL,
  attids = NULL,
  aggregate = c("minmax", "min", "max", "mean", "none"),
  name = "name",
  shift = 0.01
)
}
\arguments{
\item{model}{A \link{DexiModel} object. Required.}

\item{alternatives}{A \code{data.frame} of alternatives (normally an output of \code{\link[=evaluate]{evaluate()}}) or
indices to \code{model$alternatives}. The default value \code{NULL} selects the whole \code{model$alternatives}.}

\item{attids}{\code{character()}. A character vector of \link{DexiAttribute} IDs to be included in the result.
Default: all \code{model} attributes.}

\item{aggregate}{Determines how to aggregate DEXi values that are represented/interpreted
as sets in \code{alternatives}:
\describe{
\item{\code{"min"}}{Uses the function \code{\link[=min]{min()}} to take the minimal set element.}
\item{\code{"max"}}{Uses the function \code{\link[=max]{max()}} to take the maximal set element.}
\item{\code{"mean"}}{Uses the function \code{\link[=mean]{mean()}} to take the average set value.}
\item{\code{"minmax"} (default)}{Takes both \code{"min"} and \code{"max"}, so that each alternative
appears in the result twice.}
\item{\code{"none"}}{No aggregation.}
}
Any distributions that appear in \code{alternatives} are interpreted as sets prior to aggregation.
The default operator \code{"minmax"} is suitable particularly for alternatives containing non-single-values
(sets and/or distributions). For alternatives containing only single numeric values, any of the
other three operators is preferred.}

\item{name}{\code{character(1)}, The name of the column in \code{alternatives} that contains
alternatives' names. Default: \code{"name"}.}

\item{shift}{\code{numeric(1)}. Used to "shift" numerical values by a small amount to avoid overlapping
lines in charts. Default: \code{0.01}.}
}
\value{
A list containing the elements:
\describe{
\item{\code{data}}{A data frame containing the aggregated/scaled/shifted numeric values.}
\item{\code{nalt}}{The number of alternatives. Notice that with \code{aggregate = "minmax"},
\code{data} contains twice as many rows.}
\item{\code{groups}}{A numeric vector mapping \code{data} rows to \code{alternatives}' indices.}
\item{\code{altnames}}{Names of alternatives.}
}
}
\description{
A helper function for preparing alternatives' data for charts that involve multiple
attributes (such as \code{\link[=plotalt_parallel]{plotalt_parallel()}}) and \code{\link[=plotalt_radar]{plotalt_radar()}}).
\code{scale_alternatives()} carries out three main operations:
\enumerate{
\item{Aggregates DEXi values, represented by sets and distributions,
into single numeric values, using one of the \code{aggregate} operators:
\code{"minmax"}, \code{"min"}, \code{"max"} or \code{"mean"},}
\item{scales the aggregated values to the \verb{[0,1]} interval so that they can be
drawn uniformly on multiple chart axes,}
\item{optionally "shifts" the values by a small amount to avoid overlapping chart lines.}
}
}
\seealso{
\code{\link[=plotalt_parallel]{plotalt_parallel()}}), \code{\link[=plotalt_radar]{plotalt_radar()}})
}
