% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GetFrineGrayWeights.R
\name{getFineGrayWeights}
\alias{getFineGrayWeights}
\title{Creates a \code{Surv} object that forces in competing risks and the IPCW needed for Fine-Gray estimation.}
\usage{
getFineGrayWeights(ftime, fstatus, cvweights = NULL, cencode = 0, failcode = 1)
}
\arguments{
\item{ftime}{Numeric: Observed event (failure) times}

\item{fstatus}{Numeric: Observed event (failure) types}

\item{cvweights}{Numeric: Vector of 0/1 (cross-validation) weights for each data row}

\item{cencode}{Numeric: Code to denote censored observations (Default is 0)}

\item{failcode}{Numeric: Code to denote event of interest (Default is 1)}
}
\value{
A list that returns both an object of class \code{Surv} that forces in the competing risks indicators and a vector of weights needed for parameter estimation.
}
\description{
\code{getFineGrayWeights} creates a list \code{Surv} object and vector of weights required for estimation.
}
\examples{
ftime <- c(1, 2, 3, 4, 5, 6, 7, 8, 9, 10)
fstatus <- c(1, 2, 0, 1, 2, 0, 1, 2, 0, 1)
getFineGrayWeights(ftime, fstatus, cencode = 0, failcode = 1)
}
