% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CoxBcv.rob.R
\name{CoxBcv.rob}
\alias{CoxBcv.rob}
\title{Uncorrected robust sandwich variance estimator}
\usage{
CoxBcv.rob(Y, Delta, X, ID)
}
\arguments{
\item{Y}{vector of observed time-to-event data.}

\item{Delta}{vector of censoring indicators.}

\item{X}{matrix of marginal mean covariates with one column for one covariate (design matrix excluding intercept).}

\item{ID}{vector of cluster identifiers.}
}
\value{
\itemize{
  \item coef - estimate of coefficients.
  \item exp(coef) - estimate of hazard ratio.
  \item ROB-var - uncorrected robust sandwich variance estimate of coef.
}
}
\description{
Calculate the uncorrected robust sandwich variance estimator for marginal Cox analysis of cluster randomized trials (Spiekerman and Lin, 1998).
}
\examples{
Y <- c(11,19,43,100,7,100,100,62,52,1,7,6)
Delta <- c(1,1,1,0,1,0,0,1,1,1,1,1)
X1 <- c(0,0,0,0,0,0,1,1,1,1,1,1)
X2 <- c(-19,6,-25,48,10,-25,15,22,17,-9,45,12)
ID <- c(1,1,2,2,3,3,4,4,5,5,6,6)

X <- X1
CoxBcv.rob(Y,Delta,X,ID)

X <- cbind(X1,X2)
CoxBcv.rob(Y,Delta,X,ID)

}
\references{
Spiekerman, C. F., & Lin, D. Y. (1998). 
Marginal regression models for multivariate failure time data. 
Journal of the American Statistical Association, 93(443), 1164-1175.
}
