% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mergeEvents.R
\name{mergeEvents}
\alias{mergeEvents}
\title{Merge neighboring events of single nucleotide polymorphism (SNP), insertion and deletion.}
\usage{
mergeEvents(nucmer = nucmer)
}
\arguments{
\item{nucmer}{An object called "nucmer", mutation information derived from
"nucmer.snp" variant file by "seqkit" software and "nucmer SNP-calling"
scripts.}
}
\value{
An updated "nucmer" object.
}
\description{
The first step for handling the nucmer object, then effects of mutations
can be analysed using "indelSNP" function.
}
\examples{
#The example data:
data("nucmer")
#options(stringsAsFactors = FALSE)

#The input nucmer object can be made by the comment below:
#nucmer<-read.delim("nucmer.snps",as.is=TRUE,skip=4,header=FALSE)
#colnames(nucmer)<-c("rpos","rvar","qvar","qpos","","","","",
#"rlength","qlength","","","rname","qname")
#rownames(nucmer)<-paste0("var",1:nrow(nucmer))

# Fix IUPAC codes
nucmer<-nucmer[!nucmer$qvar\%in\%c("B","D","H","K","M","N","R","S","V","W","Y"),]
nucmer<- mergeEvents(nucmer = nucmer)## This will update the nucmer object
}
