% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/InvariantConditionalQuantilePrediction.R
\name{InvariantConditionalQuantilePrediction}
\alias{InvariantConditionalQuantilePrediction}
\title{Invariant conditional quantile prediction.}
\usage{
InvariantConditionalQuantilePrediction(Y, E, X, alpha = 0.05,
  verbose = FALSE, test = fishersTestExceedance,
  mtry = sqrt(NCOL(X)), ntree = 100, nodesize = 5, maxnodes = NULL,
  quantiles = c(0.1, 0.5, 0.9), returnModel = FALSE)
}
\arguments{
\item{Y}{An n-dimensional vector.}

\item{E}{An n-dimensional vector. If \code{test = fishersTestExceedance}, E needs
to be a factor.}

\item{X}{A matrix or dataframe with n rows and p columns.}

\item{alpha}{Significance level. Defaults to 0.05.}

\item{verbose}{If \code{TRUE}, intermediate output is provided. Defaults to \code{FALSE}.}

\item{test}{Unconditional independence test that tests whether exceedence is
independent of E. Defaults to \code{fishersTestExceedance}.}

\item{mtry}{Random forest parameter: Number of variables randomly sampled as
candidates at each split. Defaults to \code{sqrt(NCOL(X))}.}

\item{ntree}{Random forest parameter: Number of trees to grow. Defaults to 100.}

\item{nodesize}{Random forest parameter: Minimum size of terminal nodes.  Defaults to 5.}

\item{maxnodes}{Random forest parameter: Maximum number of terminal nodes trees in the forest can have.
Defaults to NULL.}

\item{quantiles}{Quantiles for which to test independence between exceedence and E.
Defaults to \code{c(0.1, 0.5, 0.9)}.}

\item{returnModel}{If \code{TRUE}, the fitted quantile regression forest model
will be returned. Defaults to \code{FALSE}.}
}
\value{
A list with the following entries:
\itemize{
 \item \code{pvalue} The p-value for the null hypothesis that Y and E are independent given X.
 \item \code{model} The fitted quantile regression forest model if \code{returnModel = TRUE}.
 }
}
\description{
Tests the null hypothesis that Y and E are independent given X.
}
\examples{
# Example 1
n <- 1000
E <- rbinom(n, size = 1, prob = 0.2)
X <- 4 + 2 * E + rnorm(n)
Y <- 3 * (X)^2 + rnorm(n)
InvariantConditionalQuantilePrediction(Y, as.factor(E), X)

# Example 2
E <- rbinom(n, size = 1, prob = 0.2)
X <- 4 + 2 * E + rnorm(n)
Y <- 3 * E + rnorm(n)
InvariantConditionalQuantilePrediction(Y, as.factor(E), X)

}
