% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/buildRelease.R
\name{buildRelease}
\alias{buildRelease}
\title{Create OMOP CDM SQL files}
\usage{
buildRelease(
  cdmVersions = listSupportedVersions(),
  targetDialects = listSupportedDialects(),
  outputfolder = file.path(tempdir(), "inst", "ddl")
)
}
\arguments{
\item{cdmVersions}{The versions of the CDM you are creating, e.g. 5.3, 5.4.
Defaults to all supported CDM versions.}

\item{targetDialects}{A character vector of target dialects.
Defaults to all supported dialects.}

\item{outputfolder}{The base folder where the SQL files will be written.
Subfolders will be created for each cdmVersion and targetDialect.}
}
\value{
Writes DDL, ForeignKey, PrimaryKey and index SQL files for given cdmVersion
        and targetDialect to the 'ddl' folder in specified output folder.
}
\description{
Writes DDL, ForeignKey, PrimaryKey and index SQL files for given cdmVersion
and targetDialect to the 'ddl' folder in specified output folder.
}
