% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/confint.R
\name{confint.lmCoDa}
\alias{confint.lmCoDa}
\title{Confidence Intervals for CoDa Models}
\usage{
\method{confint}{lmCoDa}(object, parm, level = 0.95, y_ref = NULL, obs = NULL, ...)
}
\arguments{
\item{object}{class "lmCoDa"}

\item{parm}{a character, indicating the name of one explanatory variable}

\item{level}{a numeric, indicating the confidence level required}

\item{y_ref}{an optional argument that indicates the reference component of
the response variable using its name or its position. \cr
This argument is only used in the Y-compositional model.
If it is supplied confidence intervals of difference are used instead of
the direct intervals of the parameters.}

\item{obs}{an optional integer that indicates one observation
when this argument is supplied the function return the observation
dependent elasticity}

\item{...}{passed on to confit()}
}
\value{
data.frame
}
\description{
Dargel and Thomas-Agnan (2024) show to compute variances and confidence
intervals for parameters of CoDa models in log-ratio spaces.

Of particular interest are the clr parameters since they can be directly
interpreted as differences from an average elasticity.

Another option is interpret the difference in clr parameters as these
coincide with the difference in elasticities.
}
\details{
Since CoDa models are often multivariate this function only allows to
specify one explanatory variable at a time.
The output is also more complex than the usual one for "lm" classes, because
we have to indicate the component of Y and X.
With \code{\link[=confint.lm]{confint.lm()}} it is still possible to compute the usual the confidence
intervals.
}
\examples{

## ==== Y-compositional model ====
res <- lmCoDa(
  ilr(cbind(left, right, extreme_right)) ~
  ilr(cbind(Age_1839, Age_4064)) +
  ilr(cbind(Educ_BeforeHighschool, Educ_Highschool, Educ_Higher)) +
  unemp_rate,
  data = head(election, 20))

## ---- CI for scalar X
# CI for clr parameters
confint(res, "unemp_rate")
# CI for difference in clr parameters (coincides with difference in the semi elasticity)
confint(res, "unemp_rate", y_ref = 1)

## ---- CI for compositional X
# CI for clr parameters
confint(res, "cbind(Age_1839, Age_4064)")

# CI for difference in clr parameters (coincides with difference in the elasticity)
confint(res, "cbind(Age_1839, Age_4064)", y_ref = 1)


}
\references{
\itemize{
\item Dargel, Lukas and Christine Thomas-Agnan, “Pairwise share ratio interpretations of compositional regression models”, Computational Statistics & Data Analysis 195 (2024), p. 107945
}
}
\author{
Lukas Dargel
}
