% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mcl_clusters.R
\name{mcl_cluster}
\alias{mcl_cluster}
\title{Create the files for labeling the linked clusters from ClusTCR_list_to_matrix function}
\usage{
mcl_cluster(my_file, max.iter = 10, inflation = 1, expansion = 1)
}
\arguments{
\item{my_file}{Matrix file produce from \link{ClusTCR}}

\item{max.iter}{Number of iterations to find the steady state of MCL.}

\item{inflation}{numeric value}

\item{expansion}{numeric value}
}
\value{
A list containing two elements:
\itemize{
\item 'Cluster_lab': Data frame containing information about the clusters
\item 'Normalised_tabel': Normalized table used in the clustering process
}
}
\description{
Create the files for labeling the linked clusters from ClusTCR_list_to_matrix function
}
\examples{
# Example usage of mcl_cluster function with a stored file
example_file <- read.csv(system.file("extdata", "my_data.csv",package = "ClusTCR2"))
# Perform clustering using mcl_cluster function
step1 <- ClusTCR(example_file,allele = FALSE)
# perform mcl
step2 <- mcl_cluster(step1)
}
