% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TrialPred.TwoArm.R
\name{TrialPred.TwoArm}
\alias{TrialPred.TwoArm}
\title{Function for predicting two-arm clinical trial}
\usage{
TrialPred.TwoArm(
  N.0 = NULL,
  N.1 = NULL,
  ratio = NULL,
  d = NULL,
  l = NULL,
  gamma.c = NULL,
  alpha0.t = NULL,
  nu0.t = NULL,
  HR = NULL,
  alpha1.t = NULL,
  nu1.t = NULL,
  s = NULL,
  m = NULL,
  design2 = NULL
)
}
\arguments{
\item{N.0}{number of subjects plan to be enrolled in control arm}

\item{N.1}{number of subjects plan to be enrolled in experimental arm}

\item{ratio}{randomization ratio between two arms: \code{N.1} / \code{N.0}}

\item{d}{expected number of events observed at time \code{l}}

\item{l}{observation time}

\item{gamma.c}{parameter of the exponential distribution of censoring time}

\item{alpha0.t}{shape parameter of weibull survival distribution for control arm}

\item{nu0.t}{scale parameter of weibull survival distribution for control arm}

\item{HR}{hazard ratio of experimental group over control group}

\item{alpha1.t}{shape parameters of weibull survival distribution for experimental arm}

\item{nu1.t}{scale parameter of a weibull survival distribution for control arm}

\item{s}{enrollment time}

\item{m}{maximum follow-up time for a subject}

\item{design2}{a list containing all the above parameters for two-arm design}
}
\value{
This function returns a list containing all design parameters as the same with input parameters of this function. If any one of the parameters \code{d}, \code{N.0}(or \code{N.1}), \code{l} or \code{gamma.c} is missing, it can be calculated based on the other parameters.
}
\description{
predicting two-arm clinical trial
}
\examples{
# calculate the expected number of events
TrialPred.TwoArm(N.0=100,N.1=100,d=NULL,l=6,gamma.c=1
                ,alpha0.t = 1,nu0.t=5,alpha1.t=2,nu1.t=4,s=5,m=4)

# calculate the expected number of events using a list as input
design2 <- list(N.0=100,N.1=100,d=NULL,l=6,gamma.c=1
                ,alpha0.t = 1,nu0.t=5,alpha1.t=2,nu1.t=4,s=5,m=4)
TrialPred.TwoArm(design2=design2)

# calculate the number of subject enrolled
TrialPred.TwoArm(N.0=NULL,N.1=NULL,ratio=1,d=24,l=6,gamma.c=1
                ,alpha0.t = 1,nu0.t=5,alpha1.t=2,nu1.t=4,s=5,m=4)

# calculate the observation time
TrialPred.TwoArm(N.0=100,N.1=100,d=10,l=NULL,gamma.c=1
                 ,alpha0.t = 1,nu0.t=5,alpha1.t=2,nu1.t=4,s=5,m=4)

# calculate the censoring parameter
TrialPred.TwoArm(N.0=100,N.1=100,d=10,l=3,gamma.c=NULL
                ,alpha0.t=1,nu0.t=5,alpha1.t=2,nu1.t=4,s=5,m=4)
}
