% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check_stateGraph.R
\name{check_stateGraph}
\alias{check_stateGraph}
\title{Check a stateGraph object for errors}
\usage{
check_stateGraph(stategraph)
}
\arguments{
\item{stategraph}{A stateGraph object.}
}
\value{
An error message or empty vector if no errors found.
}
\description{
Internal function to check a stateGraph object for errors.
}
\details{
Stategraph objects are more complex than what will typically be shown to the user. This function checks this hidden structure and reports any errors it finds.

These checks include rules 1-7 from Hoyal Cuthill and Lloyd (i prep.).
}
\examples{

# Make an unordered costmatrix:
costmatrix <- make_costmatrix(
  min_state = 0,
  max_state = 2,
  character_type = "unordered"
)

# Convert costmatrix to stategraph:
stategraph <- convert_costmatrix_to_stategraph(costmatrix = costmatrix)

# Check that this is a valid stateGraph object (should return empty vector):
check_stateGraph(stategraph = stategraph)

}
\author{
Graeme T. Lloyd \email{graemetlloyd@gmail.com}
}
