% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/xBitTo8Bit.R
\name{xBitTo8Bit}
\alias{xBitTo8Bit}
\title{Convert gray scale from measured bits to 8bit}
\usage{
xBitTo8Bit(im, bits)
}
\arguments{
\item{im}{Matrix of values in x bits}

\item{bits}{Number of bits of the original gray scale}
}
\value{
Matrix of gray scale values in 8bits
}
\description{
Convert gray scale from measured bits to 8bit
}
\examples{
library(oro.dicom)
file_path <- system.file("extdata", "disk.dcm", package = "CTRing")
dcm <-  readDICOM(file_path)
hdr_df <- dcm$hdr[[1]]
image_info <- getImageInfo(hdr = hdr_df)

im <- imageToMatrix(dcm$img)
range(im)

im_8bit <- xBitTo8Bit(im, image_info$grayScale)
range(im_8bit)

}
