% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/new_coin.R
\name{new_coin}
\alias{new_coin}
\title{Create a new coin}
\usage{
new_coin(
  iData,
  iMeta,
  exclude = NULL,
  split_to = NULL,
  level_names = NULL,
  retain_all_uCodes_on_split = FALSE,
  quietly = FALSE
)
}
\arguments{
\item{iData}{The indicator data and metadata of each unit}

\item{iMeta}{Indicator metadata}

\item{exclude}{Optional character vector of any indicator codes (\code{iCode}s) to exclude from the coin(s).}

\item{split_to}{This is used to split panel data into multiple coins, a so-called "purse". Should be either
\code{"all"}, or a subset of entries in \code{iData$Time}. See Details.}

\item{level_names}{Optional character vector of names of levels. Must have length equal to the number of
levels in the hierarchy (\code{max(iMeta$Level, na.rm = TRUE)}).}

\item{retain_all_uCodes_on_split}{Logical: if panel data is input and split to a purse using \code{split_to}, this controls how
units with no data at certain time points are handled. If set \code{FALSE}, then unit at time t with no data in any indicators
will be removed completely from the coin for that time point. If \code{TRUE}, all units will be included in every time point. The latter option
may be useful if you impute over time.}

\item{quietly}{If \code{TRUE}, suppresses all messages}
}
\value{
A "coin" object or a "purse" object.
}
\description{
Creates a new "coin" class object, or a "purse" class object (time-indexed collection of coins).
A purse class object is created if panel data is supplied. Coins and purses are the main object classes
used in COINr, although a number of functions also support other classes such as data frames and vectors.
}
\details{
A coin object is fundamentally created by passing two data frames to \code{\link[=new_coin]{new_coin()}}:
\code{iData} which specifies the data points for each unit and indicator, as well as other optional
variables; and \code{iMeta} which specifies details about each indicator/variable found in \code{iData},
including its type, name, position in the index, units, and other properties.

These data frames need to follow fairly strict requirements regarding their format and consistency.
Run \code{\link[=check_iData]{check_iData()}} and \code{\link[=check_iMeta]{check_iMeta()}} to validate your data frames, and these should generate helpful
error messages when things go wrong.

It is worth reading a little about coins and purses to use COINr. See \code{vignette("coins")} for more details.
\subsection{\code{iData}}{

\code{iData} should be a data frame with required column
\code{uCode} which gives the code assigned to each unit (alphanumeric, not starting with a number). All other
columns are defined by corresponding entries in \code{iMeta}, with the following special exceptions:
\itemize{
\item \code{Time} is an optional column which allows panel data to be input, consisting of e.g. multiple rows for
each \code{uCode}: one for each \code{Time} value. This can be used to split a set of panel data into multiple coins
(a so-called "purse") which can be input to COINr functions.
\item \code{uName} is an optional column which specifies a longer name for each unit. If this column is not included,
unit codes (\code{uCode}) will be used as unit names where required.
}
}

\subsection{\code{iMeta}}{

Required columns for \code{iMeta} are:
\itemize{
\item \code{Level}: Level in aggregation, where 1 is indicator level, 2 is the level resulting from aggregating
indicators, 3 is the result of aggregating level 2, and so on. Set to \code{NA} for entries that are not included
in the index (groups, denominators, etc).
\item \code{iCode}: Indicator code, alphanumeric. Must not start with a number.
\item \code{Parent}: Group (\code{iCode}) to which indicator/aggregate belongs in level immediately above.
Each entry here should also be found in \code{iCode}. Set to \code{NA} only
for the highest (Index) level (no parent), or for entries that are not included
in the index (groups, denominators, etc).
\item \code{Direction}: Numeric, either -1 or 1
\item \code{Weight}: Numeric weight, will be rescaled to sum to 1 within aggregation group. Set to \code{NA} for entries that are not included
in the index (groups, denominators, etc).
\item \code{Type}: The type, corresponding to \code{iCode}. Can be either \code{Indicator}, \code{Aggregate}, \code{Group}, \code{Denominator},
or \code{Other}.
}

Optional columns that are recognised in certain functions are:
\itemize{
\item \code{iName}: Name of the indicator: a longer name which is used in some plotting functions.
\item \code{Unit}: the unit of the indicator, e.g. USD, thousands, score, etc. Used in some plots if available.
\item \code{Target}: a target for the indicator. Used if normalisation type is distance-to-target.
}

The \code{iMeta} data frame essentially gives details about each of the columns found in \code{iData}, as well as
details about additional data columns eventually created by aggregating indicators. This means that the
entries in \code{iMeta} must include \emph{all} columns in \code{iData}, \emph{except} the three special column names: \code{uCode},
\code{uName}, and \code{Time}. In other words, all column names of \code{iData} should appear in \code{iMeta$iCode}, except
the three special cases mentioned. The \code{iName} column optionally can be used to give longer names to each indicator
which can be used for display in plots.

\code{iMeta} also specifies the structure of the index, by specifying the parent of each indicator and aggregate.
The \code{Parent} column must refer to entries that can be found in \code{iCode}. Try \code{View(ASEM_iMeta)} for an example
of how this works.

\code{Level} is the "vertical" level in the hierarchy, where 1 is the bottom level (indicators), and each successive
level is created by aggregating the level below according to its specified groups.

\code{Direction} is set to 1 if higher values of the indicator should result in higher values of the index, and
-1 in the opposite case.

The \code{Type} column specifies the type of the entry: \code{Indicator} should be used for indicators at level 1.
\code{Aggregate} for aggregates created by aggregating indicators or other aggregates. Otherwise set to \code{Group}
if the variable is not used for building the index but instead is for defining groups of units. Set to
\code{Denominator} if the variable is to be used for scaling (denominating) other indicators. Finally, set to
\code{Other} if the variable should be ignored but passed through. Any other entries here will cause an error.

Note: this function requires the columns above as specified, but extra columns can also be added without
causing errors.
}

\subsection{Other arguments}{

The \code{exclude} argument can be used to exclude specified indicators. If this is specified, \code{.$Data$Raw}
will be built excluding these indicators, as will all subsequent build operations. However the full data set
will still be stored in \code{.$Log$new_coin}. The codes here should correspond to entries in the \code{iMeta$iCode}.
This option is useful e.g. in generating alternative coins with different indicator sets, and can be included
as a variable in a sensitivity analysis.

The \code{split_to} argument allows panel data to be used. Panel data must have a \code{Time} column in \code{iData}, which
consists of some numerical time variable, such as a year. Panel data has multiple observations for each \code{uCode},
one for each unique entry in \code{Time}. The \code{Time} column is required to be numerical, because it needs to be
possible to order it. To split panel data, specify \code{split_to = "all"} to split to a single coin for each
of the unique entries in \code{Time}. Alternatively, you can pass a vector of entries in \code{Time} which allows
to split to a subset of the entries to \code{Time}.

Splitting panel data results in a so-called "purse" class, which is a data frame of COINs, indexed by \code{Time}.
See \code{vignette("coins")} for more details.

This function replaces the now-defunct \code{assemble()} from COINr < v1.0.
}
}
\examples{
# build a coin using example data frames
ASEM_coin <- new_coin(iData = ASEM_iData,
                      iMeta = ASEM_iMeta,
                      level_names = c("Indicator", "Pillar", "Sub-index", "Index"))
# view coin contents
ASEM_coin

# build example purse class
ASEM_purse <- new_coin(iData = ASEM_iData_p,
                       iMeta = ASEM_iMeta,
                       split_to = "all",
                       quietly = TRUE)
# view purse contents
ASEM_purse

# see vignette("coins") for further info

}
