% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/writeAsymmetricMeltedMatrixToDisk.R
\name{writeAsymmetricMeltedChromosomalMatrixToDisk}
\alias{writeAsymmetricMeltedChromosomalMatrixToDisk}
\title{Write a matrix, with genes, of a submatrix of a whole genome interaction matrix to disk.}
\usage{
writeAsymmetricMeltedChromosomalMatrixToDisk(
  whole_genome_matrix,
  chrom1,
  chrom2,
  extra_data_matrix = NULL,
  transpose = F,
  sequential = T,
  debug = T,
  desired_range_start = 50,
  desired_range_end = 300,
  saveToDisk = T,
  max_cap = NULL,
  rescale = T
)
}
\arguments{
\item{whole_genome_matrix}{A matrix to have edges averaged with genomic coordinates in the form chr1_50_100 set as the column and row names.}

\item{chrom1}{first chromosome of the two which will subset the matrix. (this is done in row-column fasion).}

\item{chrom2}{second chromosome of the two which will subset the matrix. (this is done in row-column fasion).}

\item{extra_data_matrix}{A matrix with additional variables about each point, one position per row with as many variables as remaining columns.}

\item{transpose}{transpose the matrix?}

\item{sequential}{disable parallelization with registerDoSEQ()?}

\item{debug}{extra output}

\item{desired_range_start}{start of range for width and height of matrix for downsampling}

\item{desired_range_end}{end of range for width and height of matrix for downsampling}

\item{saveToDisk}{saves the matrix to disk}

\item{max_cap}{maximum saturation cap, passed to signedRescale}

\item{rescale}{perform signedRescale() on matrix?}
}
\value{
ggplotmatrix a matrix with values sufficient to create a ggplot2 heatmap with geom_tile() or with ggiraph's geom_tile_interactive()
}
\description{
Writes an RData file with a ggplot2 object within.
}
\examples{
load(system.file("extdata","grch37.rda",package = "CNVScope"))
load(system.file("extdata","nbl_result_matrix_sign_small.rda",package = "CNVScope"))
load(system.file("extdata","ensembl_gene_tx_table_prot.rda",package = "CNVScope"))
writeAsymmetricMeltedChromosomalMatrixToDisk(whole_genome_matrix = 
nbl_result_matrix_sign_small,
chrom1 = 1,chrom2 = 1,desired_range_start = 25, desired_range_end = 25)
file.remove("chr1_chr1_melted.RData")
}
\keyword{genomic}
\keyword{ggiraph}
\keyword{ggplot2}
\keyword{heatmap}
\keyword{matrix}
\keyword{plotly}
