#' sumOfPosteriors
#'
#' This function is used to calculate the sum of posteriors for a given feature.
#' It returns a vector of posterior probabilities which describe how much each
#' component contributes to the distribution of features passed in.
#' @param feat Feature to calculate the sum from.
#' @param comps Component parameters for that feature
#' @param name Name of feature to sum across
#' @return Returns the sum of the posteriors for the specified feature.
sumOfPosteriors = function(feat, comps, name)
{
   curr_post = postProb(comps, feat$value)

   #Sums up the columns and normalizes by the number of features
   post_sum = c()
   for (i in unique(feat$ID)){
      sampFeats = curr_post[feat$ID==i,]
      if (!is.null(ncol(sampFeats)))
         post_sum = rbind(post_sum,colSums(sampFeats)/sum(feat$ID==i))
      else
         post_sum = rbind(post_sum,sampFeats)
   }

   colnames(post_sum) = paste0(name,1:ncol(post_sum))
   rownames(post_sum) = unique(feat$ID)

   return(post_sum)
}
