% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_doc_job_satisfaction.R
\docType{data}
\name{job_satisfaction}
\alias{job_satisfaction}
\title{Job Satisfaction data}
\format{
A data frame with 104 rows and three columns.
\describe{
\item{income}{income level categorised}
\item{satisfaction}{the level of job satisfaction for the respondent}
\item{gender}{gender of the respondent}
}
}
\source{
Agresti (2003)
}
\usage{
data(job_satisfaction)
}
\description{
Job satisfaction data based on income and gender.
}
\details{
The data relate job satisfaction and income in males and females.
Gender induces two strata; the treatments are income with categories scored
3, 10, 20 and 35 while the response is job satisfaction with categories
scored 1, 3, 4, and 5.
}
\examples{
attach(job_satisfaction)
a_ij = matrix(rep(c(3,10,20,35),2),nrow=4)
b_hj = matrix(rep(c(1,3,4,5),2),nrow=4)
unconditional_CMH(treatment = income, response = satisfaction,
strata = gender, U = 2, V = 2, a_ij = a_ij,
b_hj = b_hj)
}
\references{
Agresti, A. (2003). Categorical Data Analysis. Hoboken: John Wiley & Sons.
}
\keyword{datasets}
\keyword{job_satisfaction}
