% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coeff.OR.R
\name{coeff.OR}
\alias{coeff.OR}
\title{Compute Odds Ratios for Logistic and Conditional Logistic Regression Models}
\usage{
coeff.OR(model, variable = NULL, c = 1, confidence.level = 0.95)
}
\arguments{
\item{model}{A fitted model object from \code{glm()} (with \code{family = binomial}) or \code{survival::clogit()}.}

\item{variable}{Optional character vector specifying the variable(s) for which to compute odds ratios.  If \code{NULL} (default), checks all coefficients}

\item{c}{A numeric value specifying the increment(s) for the variables. Either a single (unnamed) numeric value
applied to all selected variables, or a named numeric vector specifying a separate increment for each. The names of \code{c} must match
the coefficient names in the model. Defaults to 1.}

\item{confidence.level}{Confidence level for the confidence interval. Defaults to 0.95.}
}
\value{
A named list containing:
\describe{
\item{\code{odds.ratio}}{Exponentiated coefficients (odds ratios).}
\item{\code{lower.limit}}{Lower bounds of the confidence intervals.}
\item{\code{upper.limit}}{Upper bounds of the confidence intervals.}
}
}
\description{
Calculates odds ratios and confidence intervals for one or more coefficients in a fitted
logistic regression model (from \code{glm}) or conditional logistic regression model
(from \code{clogit}). Also supports scaling coefficients to meaningful units (e.g., per 5 years, 5 kg, or 5 cm)
for clearer interpretation.
}
\details{
Supports both logistic regression models fit with \code{glm()} and conditional
logistic regression models fit with \code{clogit()} from the \code{survival} package.
Confidence intervals are calculated on the log-odds scale and transformed back using \code{exp()}.
}
\examples{
# Example from Hosmer et al., 2013
# Applied Logistic Regression (3rd ed.), Chapter 5, Table 5.18

# Recode 'raterisk' into a binary categorical variable 'raterisk_cat'
glow500<-dplyr::mutate(
  glow500,
  raterisk_cat = dplyr::case_when(
    raterisk \%in\% c('Less', 'Same') ~ 'C1',
    raterisk == 'Greater' ~ 'C2'))

 model.int <- glm(
   fracture ~ age + height + priorfrac + momfrac +
     armassist + raterisk_cat + age*priorfrac + momfrac*armassist,
  family = binomial, data = glow500)

 # Specify variables and interpretation units for OR computation
 var.or<-c('raterisk_catC2','height')
 units.var<-c('raterisk_catC2'=1,'height'=5)

 # Calculate and interpret adjusted odds ratios
 coeff.OR(model.int,variable = var.or, c = units.var)

}
