% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/experimental-features.R
\name{process_dataset}
\alias{process_dataset}
\title{Experimental Features for CBASS Dataset Analysis}
\usage{
process_dataset(cbass_dataset, grouping_properties)
}
\arguments{
\item{cbass_dataset}{A data frame containing the dataset to be processed.}

\item{grouping_properties}{A character vector of column names to be used for grouping. Default: c("Site", "Condition", "Species", "Timepoint").}
}
\value{
A processed data frame with the grouping property defined.
}
\description{
This script contains functions for processing and analyzing CBASS datasets, including fitting dose-response models, calculating effective doses (ED5, ED50, ED95), and plotting results.

Process the dataset by preprocessing, validating, and defining grouping properties.
}
\examples{
# Example dataset
data(cbass_dataset)

# Example grouping properties
grouping_properties <- c("Site", "Condition", "Species", "Timepoint")

# Process the dataset
processed_dataset <- process_dataset(cbass_dataset, grouping_properties)
}
