% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BP_FitBayesianPeriodicCompactness.R
\name{BP_FitBayesianPeriodicCompactness}
\alias{BP_FitBayesianPeriodicCompactness}
\title{Estimation of the likelihood of a bone section}
\usage{
BP_FitBayesianPeriodicCompactness(
  bone,
  fitted.parameters = NULL,
  priors = NULL,
  fixed.parameters = NULL,
  analysis = 1,
  silent = FALSE,
  replicates.CI = 2000,
  amplitude.max = 0.1,
  control.MHalgoGen = list(n.iter = 10000, n.chains = 1, trace = TRUE, n.adapt = 5000,
    thin = 1, adaptive = TRUE)
)
}
\arguments{
\item{bone}{The bone image to be used}

\item{fitted.parameters}{Parameters of the model to be fitted}

\item{priors}{The priors of Bayesian analysis}

\item{fixed.parameters}{Fixed parameters of the model}

\item{analysis}{Name or rank of analysis}

\item{silent}{Should the function displays some information?}

\item{replicates.CI}{Number of replicates to estimate confidence interval using Hessian}

\item{amplitude.max}{The maximum allowed amplitude for each parameter}

\item{control.MHalgoGen}{The control parameters of MHalgoGen()}
}
\value{
The -Ln L
}
\description{
Estimation of the compactness of a bone section using Bayesian periodic model.\cr
To control the parallel computing, use: \cr
options(mc.cores = [put here the number of cores you want use])\cr
options(forking = FALSE) or options(forking = TRUE)\cr
The maximum number of cores is obtained by: parallel::detectCores()\cr
}
\details{
BP_FitBayesianPeriodicCompactness estimates likelihood of global model of a bone section
}
\examples{
\dontrun{
# Not run
library(BoneProfileR)
path_Hedgehog <- system.file("extdata", "Erinaceus_europaeus_fem_2-1_small.png", 
                             package = "BoneProfileR")
 bone <- BP_OpenImage(file=path_Hedgehog)
 bone <- BP_DetectBackground(bone=bone, analysis="logistic")
 bone <- BP_DetectForeground(bone=bone, analysis="logistic")
 bone <- BP_DetectCenters(bone=bone, analysis="logistic")
 bone <- BP_EstimateCompactness(bone, analysis="logistic", cut.angle = 60)
 bone <- BP_FitMLCompactness(bone, analysis="logistic", twosteps=TRUE)
 plot(bone, type="observations+model", analysis="logistic")
 par <- BP_GetFittedParameters(bone, analysis="logistic", ML=TRUE, return.all=FALSE)[, "mean"]
 options(mc.cores=parallel::detectCores())
 
 #############################################
 # Periodic analysis
 #############################################
 bone <- BP_FitMLPeriodicCompactness(bone, analysis="logistic", control.optim=list(trace=2), 
                                     fitted.parameters=c(par, PSin=0.001, PCos=0.001, 
                                     SSin=0.001, SCos=0.001, MinSin=0.001, MinCos=0.001, 
                                     MaxSin=0.001, MaxCos=0.001), replicates.CI=2000)
 bone <- BP_FitBayesianPeriodicCompactness(bone, analysis="logistic", replicates.CI=2000)
 mcmc <- RM_get(bone, RMname="logistic", valuename="mcmcPeriodic")
 plot(mcmc, parameters="P", what="MarkovChain", ylim=c(0.555, 0.565), main="P parameter")
 
 plot(bone, type="mcmcPeriodic", parameter.name="compactness", col=rainbow(128))
 plot(bone, type="mcmcPeriodic", parameter.name="compactness", 
               col=hcl.colors(12, "YlOrRd", rev = TRUE))
 plot(bone, type="mcmcPeriodic", parameter.name="averagemodel")
 plot(bone, type="mcmcPeriodic", parameter.name="P", 
               rgb(red = 0.7, green = 0.7, blue = 0.7, alpha = 0.2))
 plot(bone, type="mcmcPeriodic", parameter.name="P", ylim=c(0, 1), 
               rgb(red = 0.7, green = 0.7, blue = 0.7, alpha = 0.2))
 
}
}
\seealso{
Other BoneProfileR: 
\code{\link{BP_AutoFit}()},
\code{\link{BP_ChooseBackground}()},
\code{\link{BP_ChooseCenter}()},
\code{\link{BP_ChooseForeground}()},
\code{\link{BP_DetectBackground}()},
\code{\link{BP_DetectCenters}()},
\code{\link{BP_DetectForeground}()},
\code{\link{BP_DuplicateAnalysis}()},
\code{\link{BP_EstimateCompactness}()},
\code{\link{BP_FitBayesianCompactness}()},
\code{\link{BP_FitMLCompactness}()},
\code{\link{BP_FitMLPeriodicCompactness}()},
\code{\link{BP_FitMLRadialCompactness}()},
\code{\link{BP_GetFittedParameters}()},
\code{\link{BP_ListAnalyses}()},
\code{\link{BP_LnLCompactness}()},
\code{\link{BP_OpenImage}()},
\code{\link{BP_Report}()},
\code{\link{Erinaceus_europaeus}},
\code{\link{plot.BoneProfileR}()},
\code{\link{summary.BoneProfileR}()}
}
\author{
Marc Girondot \email{marc.girondot@gmail.com}
}
\concept{BoneProfileR}
