% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trimTrajectory.R
\name{trimTrajectory}
\alias{trimTrajectory}
\title{Trim a trajectory object to a subset of points}
\usage{
trimTrajectory(obj, from = 1, to = nrow(obj$points))
}
\arguments{
\item{obj}{An object of class `trajectory` that contains a component `points`, which is a 
data frame with the coordinates of the points in the trajectory.}

\item{from}{A positive integer indicating the starting index of the points to include. Default is 1.}

\item{to}{A positive integer indicating the ending index of the points to include. Default is 
the total number of rows in `obj$points`.}
}
\value{
A new trajectory object created using the subset of points from the `from` to `to` indices.
}
\description{
This function trims the points of a `trajectory` object by selecting a subset of the points 
from the specified `from` to `to` indices. It then creates a new trajectory using the selected 
points.
}
