% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visualization.r
\name{viz_thermal_montage2}
\alias{viz_thermal_montage2}
\title{Create a Thermal Image Montage}
\usage{
viz_thermal_montage2(
  img_list,
  ncol = NULL,
  padding = 10,
  palette = "inferno",
  text_color = "white",
  text_size = 4
)
}
\arguments{
\item{img_list}{A list of 'BioThermR' objects.}

\item{ncol}{Integer. Number of columns in the grid. If NULL, tries to create a roughly square grid.}

\item{padding}{Integer. Pixel gap between images. Default is 10.}

\item{palette}{String. Color palette for temperature. Default is "inferno".}

\item{text_color}{String. Color of the filename labels. Default is "white" (good contrast on dark backgrounds).}

\item{text_size}{Integer. Font size of the labels. Default is 4.}
}
\value{
A ggplot object.
}
\description{
Combines multiple BioThermR objects into a single plot (a montage/collage).
             Images are laid out in a grid, and filenames are labeled above each image.
             Uses the 'processed' matrix (NA values are transparent).
}
\examples{
\donttest{
# Load a batch of images
img_obj_list <- system.file("extdata",package = "BioThermR")
batch <- read_thermal_batch(img_obj_list)

# Create a montage2 with 4 columns
p <- viz_thermal_montage2(batch, ncol = 4, padding = 20)
}
}
