% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Utilities.R
\name{scat_cont_plot}
\alias{scat_cont_plot}
\title{Scatter Plot for a Biomarker Associated with Continuous Outcome}
\usage{
scat_cont_plot(
  yvar,
  xvar,
  data,
  ybreaks = NULL,
  xbreaks = NULL,
  yvar.display = yvar,
  xvar.display = xvar
)
}
\arguments{
\item{yvar}{Continuous response variable name.}

\item{xvar}{biomarker name.}

\item{data}{The dataset containing the variables.}

\item{ybreaks}{Breaks on the y-axis.}

\item{xbreaks}{Breaks on the x-axis.}

\item{yvar.display}{Display name for the response variable.}

\item{xvar.display}{Display name for the biomarker variable.}
}
\value{
A list containing correlation coefficients, scatter plot, slope, and intercept.
}
\description{
Generates a scatter plot for exploring the relationship between a continuous response variable
and a biomarker variable.
}
\examples{
data <- data.frame(
  outcome = rnorm(100, mean = 10, sd = 2),
  biomarker = rnorm(100, mean = 0, sd = 1)
)

# Generate a scatter plot with default axis breaks
scat_cont_plot(
  yvar = "outcome",
  xvar = "biomarker",
  data = data,
  yvar.display = "Continuous Outcome",
  xvar.display = "Biomarker Level"
)

# Generate a scatter plot with specified axis breaks
scat_cont_plot(
  yvar = "outcome",
  xvar = "biomarker",
  data = data,
  ybreaks = seq(5, 15, by = 1),
  xbreaks = seq(-2, 2, by = 0.5),
  yvar.display = "Continuous Outcome",
  xvar.display = "Biomarker Level"
)
}
