% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lqmm.R
\name{lqmm}
\alias{lqmm}
\title{\code{lqmm} fits linear quantile mixed model}
\usage{
lqmm(
  formFixed,
  formRandom,
  formGroup,
  data,
  tau,
  RE_ind = FALSE,
  n.chains = 3,
  n.iter = 10000,
  n.burnin = 5000,
  n.thin = 1,
  n.adapt = NULL,
  precision = 10,
  save_jagsUI = TRUE,
  parallel = FALSE
)
}
\arguments{
\item{formFixed}{formula for fixed part of longitudinal submodel with response variable}

\item{formRandom}{formula for random part of longitudinal submodel without response variable}

\item{formGroup}{formula specifying the cluster variable (e.g. = ~ subject)}

\item{data}{dataset of observed variables}

\item{tau}{the quantile(s) to be estimated. This must be a number between 0 and 1, otherwise the execution is stopped. If more than one quantile is specified, rounding off to the 4th decimal must give non–duplicated values of \code{tau}, otherwise the execution is stopped.}

\item{RE_ind}{Boolean denoting if the random effects are assumed independent ; default is \code{FALSE}}

\item{n.chains}{the number of parallel chains for the model; default is 1.}

\item{n.iter}{integer specifying the total number of iterations; default is 10000}

\item{n.burnin}{integer specifying how many of \code{n.iter} to discard as burn-in ; default is 5000}

\item{n.thin}{integer specifying the thinning of the chains; default is 1}

\item{n.adapt}{integer specifying the number of iterations to use for adaptation; default is \code{NULL}}

\item{precision}{variance by default for vague prior distribution}

\item{save_jagsUI}{If \code{TRUE} (by default), the output of \code{jagsUI} package is returned by the function. Warning, if \code{TRUE}, the output can be large.}

\item{parallel}{see \code{jagsUI::jags()} function}
}
\value{
A \code{Blqmm} object is a list with the following elements:
\describe{
\item{\code{mean}}{list of posterior mean for each parameter}
\item{\code{median}}{list of posterior median for each parameter}
\item{\code{modes}}{list of posterior mode for each parameter}
\item{\code{StErr}}{list of standard error for each parameter}
\item{\code{StDev}}{list of standard deviation for each parameter}
\item{\code{ICs}}{list of the credibility interval at 0.95 for each parameters excepted for covariance parameters in covariance matrix of random effects. Otherwise, use save_jagsUI=TRUE to have the associated quantiles.}
\item{\code{data}}{data included in argument}
\item{\code{sims.list}}{list of the MCMC chains of the parameters and random effects}
\item{\code{control}}{list of arguments giving details about the estimation}
\item{\code{random_effect}}{list for each quantile including both posterior mean and posterior standard deviation of subject-specific random effects}
\item{\code{out_jagsUI}}{only if \code{save_jagsUI=TRUE} in argument: list including posterior mean, median, quantiles (2.5\%, 25\%, 50\%, 75\%, 97.5\%), standart deviation for each parameter and each random effect.
Moreover, this list also returns the MCMC draws, the Gelman and Rubin diagnostics (see output of jagsUI objects)}
}
}
\description{
Function using 'JAGS' software to estimate the linear quantile mixed model assuming asymmetric Laplace
distribution for residual error.
}
\examples{

\donttest{
#---- Use dataLong dataset
data(dataLong)

#---- Fit regression model for the first quartile
lqmm_075 <- lqmm(formFixed = y ~ visit,
                 formRandom = ~ visit,
                 formGroup = ~ ID,
                 data = dataLong,
                 tau = 0.75,
                 n.iter = 10000,
                 n.burnin = 1000)

#---- Get the posterior means
lqmm_075$mean

#---- Visualize the trace for beta parameters
jagsUI::traceplot(lqmm_075$out_jagsUI, parameters = "beta")

#---- Summary of output
summary(lqmm_075)
}

}
\references{
Marco Geraci and Matteo Bottai (2014).
\emph{Linear quantile mixed models}.
Statistics and Computing, 24(3):461-479. doi: 10.1007/s11222-013-9381-9.
}
\author{
Antoine Barbieri
}
