% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lqm.R
\name{lqm}
\alias{lqm}
\title{\code{lqm} fits linear quantile regression model}
\usage{
lqm(
  formula,
  data,
  tau = 0.5,
  n.chains = 3,
  n.iter = 10000,
  n.burnin = 5000,
  n.thin = 1,
  n.adapt = NULL,
  save_jagsUI = TRUE,
  parallel = FALSE
)
}
\arguments{
\item{formula}{formula for the quantile regression including response variable}

\item{data}{dataset of observed variables}

\item{tau}{the quantile(s) to be estimated. This must be a number between 0 and 1, otherwise the execution is stopped. If more than one quantile is specified, rounding off to the 4th decimal must give non–duplicated values of \code{tau}, otherwise the execution is stopped.}

\item{n.chains}{the number of parallel chains for the model; default is 1.}

\item{n.iter}{integer specifying the total number of iterations; default is 10000}

\item{n.burnin}{integer specifying how many of \code{n.iter} to discard as burn-in ; default is 5000}

\item{n.thin}{integer specifying the thinning of the chains; default is 1}

\item{n.adapt}{integer specifying the number of iterations to use for adaptation; default is \code{NULL}}

\item{save_jagsUI}{If \code{TRUE} (is \code{TRUE} by default), the output of \code{jagsUI} package is return by the function}

\item{parallel}{see \code{jagsUI::jags()} function}
}
\value{
A \code{Blqm} object which is a list with the following elements:
\describe{
\item{\code{mean}}{list of posterior mean for each parameter}
\item{\code{median}}{list of posterior median for each parameter}
\item{\code{modes}}{list of posterior mode for each parameter}
\item{\code{StErr}}{list of standard error for each parameter}
\item{\code{StDev}}{list of standard deviation for each parameter}
\item{\code{Rhat}}{Gelman and Rubin diagnostic for all parameters}
\item{\code{ICs}}{list of the credibility interval at 0.95 for each parameters excepted for covariance parameters in covariance matrix of random effects. Otherwise, use save_jagsUI=TRUE to have the associated quantiles.}
\item{\code{data}}{data included in argument}
\item{\code{sims.list}}{list of the MCMC chains of the parameters and random effects}
\item{\code{control}}{list of arguments giving details about the estimation}
\item{\code{W}}{list including both posterior mean and posterior standard deviation of subject-specific random variable W}
\item{\code{out_jagsUI}}{only if \code{save_jagsUI=TRUE} in argument: list including posterior mean, median, quantiles (2.5\%, 25\%, 50\%, 75\%, 97.5\%), standard deviation for each parameter and each random effect.
Moreover, this list also returns the MCMC draws, the Gelman and Rubin diagnostics (see output of jagsUI objects)}
}
}
\description{
Function using 'JAGS' software to estimate the linear quantile regression model assuming asymmetric Laplace
distribution for residual error.
}
\examples{

\donttest{
#---- Use data
data(wave)

#---- Fit regression model for the first quartile
lqm_025 <- lqm(formula = h110d~vent_vit_moy,
               data = wave,
               n.iter = 1000,
               n.burnin = 500,
               tau = 0.25)

#---- Get the posterior mean of parameters
lqm_025$mean

#---- Visualize the trace for beta parameters
jagsUI::traceplot(lqm_025$out_jagsUI, parameters = "beta" )

#---- Summary of output
summary(lqm_025)
}

}
\author{
Antoine Barbieri
}
