% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/posterior_inference.R
\name{plot_location}
\alias{plot_location}
\title{Plot a location's time series of estimated/predicted values.}
\usage{
plot_location(
  out,
  location,
  new_x = NULL,
  type = "mean",
  par.mfrow = c(1, 1),
  pred.int = FALSE,
  ci.level = c(0.025, 0.975),
  uncertainty = TRUE,
  xrange = NULL,
  truth = FALSE,
  ylim = NULL
)
}
\arguments{
\item{out}{Output from BSTFA or BSTFAfull.}

\item{location}{Either a single integer indicating the location in the data set to plot or a vector of length 2 providing the longitude and latitude of the new location.}

\item{new_x}{If the original model included covariates \code{x}, include the same covariates for prediction \code{location}.}

\item{type}{One of \code{mean} (default), \code{median}, \code{ub}, or \code{lb} indicating which summary statistic of the predicted values to return.}

\item{par.mfrow}{A vector of length 2 indicating the number of rows and columns to divide the plotting window. Default is \code{c(1,1)}.}

\item{pred.int}{Logical scalar indicating whether the interval should be a posterior predictive interval (\code{TRUE}) or a posterior credible interval (\code{FALSE}; default).}

\item{ci.level}{If \code{type='lb'} or \code{'ub'}, the percentiles for the posterior interval.}

\item{uncertainty}{Logical scalar indicating whether to plot the uncertainty bounds (\code{TRUE}; default) or not.}

\item{xrange}{A date vector of length 2 providing the lower and upper bounds of the dates to include in the plot.}

\item{truth}{Logical scalar indicating whether to include the observed measurements (\code{TRUE}) or not (default).  If \code{TRUE}, \code{location} must be an integer corresponding to the column of the data matrix for the in-sample prediction location.}

\item{ylim}{Numeric vector of length 2 providing the lower and upper bounds of the y-axis.  If \code{NULL} (default), the y-axis limits are chosen using the range of the predictions.}
}
\value{
A plot of predicted values for \code{location}.
}
\description{
Plot a location's time series of estimated/predicted values.
}
\examples{
data(out.sm)
attach(out.sm)
plot_location(out.sm, location=1, pred.int=FALSE)
}
\author{
Candace Berrett and Adam Simpson
}
