% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/posterior_diagnostics.R
\name{compute_summary}
\alias{compute_summary}
\title{Print computation summary}
\usage{
compute_summary(out)
}
\arguments{
\item{out}{Output from BSTFA or BSTFAfull.}
}
\value{
Prints the computation time per iteration for each parameter.
}
\description{
Print computation summary
}
\examples{
data(utahDataList)
attach(utahDataList)
low.miss <- which(apply(is.na(TemperatureVals), 2, mean)<.02)
out <- BSTFA(ymat=TemperatureVals[1:50,low.miss],
  dates=Dates[1:50],
  coords=Coords[low.miss,],
  n.factors=2,
  iters=10,
  save.time=TRUE)
compute_summary(out)
}
\author{
Adam Simpson
}
