% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BSDA-package.R
\docType{data}
\name{Abilene}
\alias{Abilene}
\title{Crimes reported in Abilene, Texas}
\format{
A data frame/tibble with 16 observations on three variables
\describe{ 
\item{crimetype}{a character variable with values \code{Aggravated
assault}, \code{Arson}, \code{Burglary}, \code{Forcible rape}, \code{Larceny
theft}, \code{Murder}, \code{Robbery}, and \code{Vehicle theft}.}
\item{year}{a factor with levels \code{1992} and \code{1999}} 
\item{number}{number of reported crimes} 
}
}
\source{
\emph{Uniform Crime Reports}, US Dept. of Justice.
}
\usage{
Abilene
}
\description{
Data used in Exercise 1.23 and 2.79
}
\examples{

par(mfrow = c(2, 1))
barplot(Abilene$number[Abilene$year=="1992"],
names.arg = Abilene$crimetype[Abilene$year == "1992"],
main = "1992 Crime Stats", col = "red")
barplot(Abilene$number[Abilene$year=="1999"],
names.arg = Abilene$crimetype[Abilene$year == "1999"],
main = "1999 Crime Stats", col = "blue")
par(mfrow = c(1, 1))

\dontrun{
library(ggplot2)
ggplot2::ggplot(data = Abilene, aes(x = crimetype, y = number, fill = year)) +
           geom_bar(stat = "identity", position = "dodge") +
           theme_bw() +
           theme(axis.text.x = element_text(angle = 30, hjust = 1))
}

}
\references{
Kitchens, L. J. (2003) \emph{Basic Statistics and Data Analysis}.
Pacific Grove, CA: Brooks/Cole, a division of Thomson Learning.
}
\keyword{datasets}
