% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/regression_summary.R
\name{regression_summary}
\alias{regression_summary}
\title{Summarary Method for Multivariate or Univarate Regression}
\usage{
regression_summary(object, cred = 0.95, ...)
}
\arguments{
\item{object}{An object of class \code{estimate}}

\item{cred}{Numeric. The credible interval width for summarizing the posterior
distributions (defaults to 0.95; must be between 0 and 1).}

\item{...}{Currently ignored}
}
\value{
A list of length \emph{p} including the
        summaries for each regression.
}
\description{
Summarary Method for Multivariate or Univarate Regression
}
\examples{
\donttest{
# note: iter = 250 for demonstrative purposes

# data
Y <- bfi

Y <- subset(Y, select = c("A1", "A2", 
                          "gender", "education"))

fit_mv_ordinal <- estimate(Y, formula = ~ gender + as.factor(education),
                           type = "continuous",
                           iter = 250,
                           progress = TRUE)

regression_summary(fit_mv_ordinal)
}
}
