% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/all_diagnostics.R
\name{contour.angmcmc}
\alias{contour.angmcmc}
\title{Contour plot for angmcmc objects with bivariate data}
\usage{
\method{contour}{angmcmc}(
  x,
  fn = "MAP",
  type = "point-est",
  show.data = TRUE,
  xpoints = seq(0, 2 * pi, length.out = 100),
  ypoints = seq(0, 2 * pi, length.out = 100),
  levels,
  nlevels = 20,
  cex = 1,
  col = "red",
  alpha = 0.4,
  pch = 19,
  ...
)
}
\arguments{
\item{x}{angular MCMC object (with bivariate data).}

\item{fn}{function, or a single character string specifying its name, to evaluate on MCMC samples to estimate
parameters.  Defaults to \code{mean}, which computes the estimated posterior mean.
Note that if \code{fn = "MODE"} (warning: not \code{"mode"}) or \code{fn = "MAP"}, then the maximum aposteriori estimate (MAP) is
calculated.}

\item{type}{Passed to \link{d_fitted}. Possible choices are "point-est" and "post-pred".}

\item{show.data}{logical. Should the data points be added to the contour plot? Ignored if \code{object} is NOT supplied.}

\item{xpoints}{Points on the first (x-) coordinate where the density is to be evaluated.
Default to seq(0, 2*pi, length.out=100).}

\item{ypoints}{Points on the first (x-) coordinate where the density is to be evaluated.
Default to seq(0, 2*pi, length.out=100).}

\item{levels}{numeric vector of levels at which to draw contour lines;
passed to the \link{contour} function in graphics.}

\item{nlevels}{number of contour levels desired \strong{if} levels is not supplied;
passed to the \link{contour} function in graphics.}

\item{cex, col, pch}{graphical parameters passed to \link{points} from graphics for plotting the data points.
Ignored if \code{show.data == FALSE}.}

\item{alpha}{color transparency for the data points, implemented via \link[scales]{alpha} from package \code{scales}.
Ignored if \code{show.data == FALSE}.}

\item{...}{additional arguments to be passed to the function \link{contour}.}
}
\description{
Contour plot for angmcmc objects with bivariate data
}
\details{
\code{contour.angmcmc} is an S3 function for \code{angmcmc} objects that calls \link{contour} from graphics.

To estimate the mixture density required to construct the contour plot, first the parameter vector \eqn{\eta} is estimated
by applying \code{fn} on the MCMC samples, yielding the (consistent) Bayes estimate \eqn{\hat{\eta}}. Then the mixture density
\eqn{f(x|\eta)} at any point \eqn{x} is (consistently) estimated by \eqn{f(x|\hat{\eta})}.
}
\examples{
# first fit a vmsin mixture model
# illustration only - more iterations needed for convergence
fit.vmsin.20 <- fit_vmsinmix(tim8, ncomp = 3, n.iter =  20,
                             n.chains = 1)
# now create a contour plot
contour(fit.vmsin.20)

}
