% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/customvision_publish.R
\name{publish_model}
\alias{publish_model}
\alias{unpublish_model}
\alias{export_model}
\alias{list_model_exports}
\title{Publish, export and unpublish a Custom Vision model iteration}
\usage{
publish_model(model, name, prediction_resource)

unpublish_model(model, confirm = TRUE)

export_model(model, format, destfile = basename(httr::parse_url(dl_link)$path))

list_model_exports(model)
}
\arguments{
\item{model}{A Custom Vision model iteration object.}

\item{name}{For \code{publish_model}, the name to assign to the published model on the prediction endpoint.}

\item{prediction_resource}{For \code{publish_model}, the Custom Vision prediction resource to publish to. This can either be a string containing the Azure resource ID, or an AzureRMR resource object.}

\item{confirm}{For \code{unpublish_model}, whether to ask for confirmation first.}

\item{format}{For \code{export_model}, the format to export to. See below for supported formats.}

\item{destfile}{For \code{export_model}, the destination file for downloading. Set this to NULL to skip downloading.}
}
\value{
\code{export_model} returns the URL of the exported file, invisibly if it was downloaded.

\code{list_model_exports} returns a data frame detailing the formats the current model has been exported to, along with their download URLs.
}
\description{
Publish, export and unpublish a Custom Vision model iteration
}
\details{
Publishing a model makes it available to clients as a predictive service. Exporting a model serialises it to a file of the given format in Azure storage, which can then be downloaded. Each iteration of the model can be published or exported separately.

The \code{format} argument to \code{export_model} can be one of the following. Note that exporting a model requires that the project was created with support for it.
\itemize{
\item \code{"onnx"}: ONNX 1.2
\item \code{"coreml"}: CoreML, for iOS 11 devices
\item \code{"tensorflow"}: TensorFlow
\item \code{"tensorflow lite"}: TensorFlow Lite for Android devices
\item \code{"linux docker"}, \code{"windows docker"}, \code{"arm docker"}: A Docker image for the given platform (Raspberry Pi 3 in the case of ARM)
\item \code{"vaidk"}: Vision AI Development Kit
}
}
\examples{
\dontrun{

endp <- customvision_training_endpoint(url="endpoint_url", key="key")
myproj <- get_project(endp, "myproject")
mod <- get_model(myproj)

export_model(mod, "tensorflow", download=FALSE)
export_model(mod, "onnx", destfile="onnx.zip")

rg <- AzureRMR::get_azure_login("yourtenant")$
    get_subscription("sub_id")$
    get_resource_group("rgname")

pred_res <- rg$get_cognitive_service("mycustvis_prediction")
publish_model(mod, "mypublishedmod", pred_res)

unpublish_model(mod)

}
}
\seealso{
\code{\link{train_model}}, \code{\link{get_model}}, \code{\link{customvision_predictive_service}}, \code{\link{predict.classification_service}}, \code{\link{predict.object_detection_service}}
}
