% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/frontend.R
\name{save_response_rds}
\alias{save_response_rds}
\title{Write query records as an RDS file}
\usage{
save_response_rds(query, filename)
}
\arguments{
\item{query}{The query object to be saved.}

\item{filename}{(character) Name of the file to be saved.}
}
\value{
Nothing.
}
\description{
Save the query object as an RDS file, which stores the entire state of the
query and can be loaded at a later time.
}
\examples{
library(ArctosR)

if (interactive()) {
  # Request to download all available data
  query <- get_records(
    scientific_name = "Canis lupus", guid_prefix = "MSB:Mamm",
    columns = list("guid", "parts", "partdetail")
  )

  # Save the data in a .RDS file
  save_response_rds(query, "wolves.RDS")


  \dontshow{
  unlink("wolves.RDS")
  }
}

}
